import { Link } from 'wouter';
import { Button } from "@/components/ui/button";

export function AboutSection() {
  return (
    <section id="about" className="py-20 bg-slate-50 px-4 sm:px-6 lg:px-8">
      <div className="container mx-auto">
        <div className="grid md:grid-cols-2 gap-12 items-center">
          <div className="order-2 md:order-1">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">About ServiceDesk Experts</h2>
            <p className="text-lg text-slate-600 mb-6">
              We are a team of certified IT service management professionals dedicated to helping 
              organizations optimize their service desk platforms.
            </p>
            
            <p className="text-slate-600 mb-6">
              With over 10 years of industry experience, we've helped hundreds of companies implement
              efficient, user-friendly service management solutions that reduce costs and improve
              service delivery.
            </p>
            
            <div className="grid grid-cols-2 gap-6 mb-8">
              <div>
                <div className="text-3xl font-bold text-primary-600 mb-2">500+</div>
                <p className="text-slate-700">Successful Projects</p>
              </div>
              <div>
                <div className="text-3xl font-bold text-primary-600 mb-2">98%</div>
                <p className="text-slate-700">Client Satisfaction</p>
              </div>
            </div>
            
            <Button 
              asChild
              className="bg-primary-600 hover:bg-primary-700 text-white" 
              size="lg"
            >
              <Link href="#contact">Work With Us</Link>
            </Button>
          </div>
          
          <div className="order-1 md:order-2 grid grid-cols-2 gap-4">
            <div className="space-y-4">
              <div className="rounded-lg shadow-md h-64 w-full bg-[url('https://images.unsplash.com/photo-1522071820081-009f0129c71c?ixlib=rb-1.2.1&auto=format&fit=crop&w=400&q=80')] bg-cover bg-center"></div>
              <div className="rounded-lg shadow-md h-48 w-full bg-[url('https://images.unsplash.com/photo-1551434678-e076c223a692?ixlib=rb-1.2.1&auto=format&fit=crop&w=400&q=80')] bg-cover bg-center"></div>
            </div>
            <div className="space-y-4 mt-8">
              <div className="rounded-lg shadow-md h-48 w-full bg-[url('https://images.unsplash.com/photo-1573497620053-ea5300f94f21?ixlib=rb-1.2.1&auto=format&fit=crop&w=400&q=80')] bg-cover bg-center"></div>
              <div className="rounded-lg shadow-md h-64 w-full bg-[url('https://images.unsplash.com/photo-1603201667141-5a2d4c673378?ixlib=rb-1.2.1&auto=format&fit=crop&w=400&q=80')] bg-cover bg-center"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
