import { Link } from 'wouter';
import { Button } from "@/components/ui/button";

export function HeroSection() {
  return (
    <section className="hero-gradient pt-32 pb-20 px-4 sm:px-6 lg:px-8 text-white">
      <div className="container mx-auto">
        <div className="max-w-3xl mx-auto text-center">
          <h1 className="text-4xl md:text-5xl font-bold mb-6">
            Professional Service Desk Configuration Experts
          </h1>
          <p className="text-xl text-primary-50 mb-8">
            We optimize your service management tools to enhance IT efficiency and improve user satisfaction.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button
              asChild
              size="lg"
              variant="default"
              className="bg-white text-primary-700 hover:bg-primary-50"
            >
              <Link href="#services">Explore Services</Link>
            </Button>
            <Button
              asChild
              size="lg"
              variant="default"
              className="bg-accent text-white hover:bg-accent/90"
            >
              <Link href="#contact">Contact Us</Link>
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
}
